/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.internal.history.GitHistoryPageSource;
import com.aptana.ui.util.UIUtils;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class ShowInHistoryHandler
extends AbstractHandler {
    private boolean enabled;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Object evaluationContext) {
        GitRepository repo;
        IResource resource;
        if (evaluationContext instanceof IEvaluationContext && (resource = this.getResource((IEvaluationContext)evaluationContext)) != null && (repo = this.getGitRepositoryManager().getAttached(resource.getProject())) != null) {
            this.enabled = true;
            return;
        }
        this.enabled = false;
    }

    protected IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource resource;
        if (event == null) {
            return null;
        }
        Object context = event.getApplicationContext();
        if (context instanceof IEvaluationContext && (resource = this.getResource((IEvaluationContext)context)) != null) {
            IWorkbenchPage page = UIUtils.getActivePage();
            TeamUI.showHistoryFor((IWorkbenchPage)page, (Object)resource, (IHistoryPageSource)GitHistoryPageSource.getInstance());
        }
        return null;
    }

    private IResource getResource(IEvaluationContext evContext) {
        block8: {
            Object input;
            block7: {
                Object[] selectedFiles;
                input = evContext.getVariable("showInInput");
                if (input instanceof IFileEditorInput) {
                    IFileEditorInput fei = (IFileEditorInput)input;
                    return fei.getFile();
                }
                Object selection = evContext.getVariable("selection");
                if (selection instanceof ITextSelection && (input = evContext.getVariable("activeEditorInput")) instanceof IFileEditorInput) {
                    IFileEditorInput fei = (IFileEditorInput)input;
                    return fei.getFile();
                }
                input = evContext.getDefaultVariable();
                if (!(input instanceof IStructuredSelection)) break block7;
                IStructuredSelection ss = (IStructuredSelection)input;
                Object[] objectArray = selectedFiles = ss.toArray();
                int n = selectedFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (selected instanceof IResource) {
                        return (IResource)selected;
                    }
                    if (selected instanceof IAdaptable) {
                        return (IResource)((IAdaptable)selected).getAdapter(IResource.class);
                    }
                    ++n2;
                }
                break block8;
            }
            if (!(input instanceof Collection)) break block8;
            Collection selectedFiles = (Collection)input;
            for (Object selected : selectedFiles) {
                if (selected instanceof IResource) {
                    return (IResource)selected;
                }
                if (!(selected instanceof IAdaptable)) continue;
                return (IResource)((IAdaptable)selected).getAdapter(IResource.class);
            }
        }
        return null;
    }
}

